
# Vol 1 Tick‑Algebra Commutator

**Volume 1 – Section 2A.4.1 Simulation**  
Toy‑model demonstration of irreversibility in the Absolute Relativity “tick algebra” via non‑zero operator commutators.

---

## 📜 Overview

This repository contains a minimal Python implementation of the 4×4 “tick‑algebra” commutator test from Volume 1, Section 2A.4.1:

- **Renewal operator** \(\hat R\)  
- **Sink operator** \(\hat S\)  
- **Collapse projector** \(\hat C\)

We compute the commutators
\[
[R,S],\quad [C,R],\quad [C,S]
\]
and their operator 2‑norms, verifying:

- \(\|[R,S]\|\neq0\) (→ time‑arrow / irreversibility)  
- \(\|[C,R]\|=\|[C,S]\|=0\)

This provides a concrete, code‑based validation of the theoretical claims in Volume 1.

---

## 🛠️ Installation

1. **Clone the repo**  
   ```bash
   git clone git@github.com:YourUsername/vol1-tick-commutator.git
   cd vol1-tick-commutator
````

2. **Create a virtual environment** (optional but recommended)

   ```bash
   python3 -m venv .venv
   source .venv/bin/activate   # macOS/Linux
   .venv\Scripts\activate      # Windows
   ```

3. **Install dependencies**

   ```bash
   pip install -r requirements.txt
   ```

---

## ▶️ Usage

Run the commutator script:

```bash
python commutator.py
```

This will:

1. Define the matrices $\hat R$, $\hat S$, and $\hat C$.
2. Compute the commutators and their 2‑norms.
3. Write the results to `results/commutator_norms.csv`.

---

## 📊 Results

The output CSV (`results/commutator_norms.csv`) has the format:

| comm   | norm     |
| :----- | :------- |
| \[R,S] | 0.765432 |
| \[C,R] | 0.000000 |
| \[C,S] | 0.000000 |

Use these values as the first validated simulation of Volume 1.

---

## ⚙️ Configuration

* **Sink damping factor** `s` in `commutator.py` can be adjusted (default `s=1.0`).
* To re‑compute with a different `s`, simply edit the value at the top of `commutator.py` and re‑run.

---

## 🧪 Next Steps

Once this test is validated:

1. Move on to the **Toy‑Model Casimir** simulation (`vol1-toy-casimir`).
2. Then implement the **Frame‑Coupling Constant** calculation (`vol1-frame-coupling`).
3. Integrate all three into your Volume 1 validation suite.

---

## License

This project is licensed under the MIT License.  
See the [LICENSE](LICENSE) file for details.

---

*Generated as part of the Absolute Relativity Volume 1 simulation validation.*

```
